<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\LoginController;
use App\Http\Controllers\AppController;
use Carbon\Carbon;
/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/


Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});


Route::post('/userapplogin', 'Auth\LoginController@loginapp');
//Route::logout('/logoutapp', [AuthController::class, 'logout'])->middleware('auth:sanctum');

Route::middleware('auth:sanctum')->get('/openappcases', function (Request $request) {  

    $getopencases  = DB::connection('mysqllive')->table('lawyerfinaldocuments')->where('shareto' , $request->user()->id)->where('caseclose', 0)->get();
    return $getopencases;
    return response()->json([
        'status' => 'success',
        'records' => $getopencases
    ], 200);
  
   
});


Route::middleware('auth:sanctum')->get('/closeappcases', function (Request $request) {

    $getclosecases = DB::connection('mysqllive')->table('lawyerfinaldocuments')->where('shareto' , $request->user()->id)->where('caseclose', 1)->get();
   
    return response()->json([
        'status' => 'success',
        'records' => $getclosecases,
    ], 200);

});


Route::middleware('auth:sanctum')->post('/addremarks', function (Request $request) {

    DB::connection('mysqllive')->insert('insert into lawyercaseremarks(remark, laywer_id, case_id, created_at, updated_at) values (?, ?, ?, ?, ?)',
            [$request['remark'], 
            $request->user()->id,
            $request['case_id'] , 
            Carbon::now(), 
            Carbon::now() ]);        

    return response()->json([
        'status' => 'success',
        'message' => 'Remarks added successfully'
    ], 200);

});



Route::middleware('auth:sanctum')->get('/viewcaseremarks', function (Request $request) {
    
    $getcaseremarks = DB::connection('mysqllive')->table('lawyercaseremarks')->where('case_id' , $request->case_id)->get();

    return response()->json([
        'status' => 'success',
        'records' => $getcaseremarks
    ], 200);    
   
});



Route::middleware('auth:sanctum')->post('/casestatusclose', function(Request $request) {
     
     
    $record = DB::connection('mysqllive')->table('lawyerfinaldocuments')->where('id', $request->case_id)->first();

    // Check if the record was found
    if ($record) {
       
        DB::connection('mysqllive')->table('lawyerfinaldocuments')->where('id', $request->case_id)->update(['caseclose' => 1]);
           
            // Return a success message as a JSON response
            return response()->json([
                'status' => 'success',
                'message' => 'Case Close Successfully'
            ], 200);

        } else {
           
            // Return an error message as a JSON response
            return response()->json([
                'status' => 'error',
                'message' => 'Record not found'
            ], 404);
        }
    });



Route::middleware('auth:sanctum')->post('/casestatusopen', function(Request $request) {     
     
    $record = DB::connection('mysqllive')->table('lawyerfinaldocuments')->where('id', $request->case_id)->first();
    // Check if the record was found
    if ($record) {
       
         DB::connection('mysqllive')->table('lawyerfinaldocuments')->where('id', $request->case_id)->update(['caseclose' => 0]);
        // Return a success message as a JSON response
        return response()->json([
            'status' => 'success',
            'message' => 'Case Open Successfully'
        ], 200);
    } else {
        // Return an error message as a JSON response
        return response()->json([
            'status' => 'error',
            'message' => 'Record not found'
        ], 404);
    }
    });
