@extends('layouts.argon')


@section('content')

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<link rel="stylesheet" href="https://code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
<script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
    <style>
        .tags {
            display: flex;
            flex-wrap: wrap;
            gap: 10px;
        }

        .tag {
            display: inline-block;
            padding: 0px 5px;
            background-color: #0c6632;
            color: white;
            border-radius: 5px;
            cursor: pointer;
        }

        .tag:hover {
            background-color: #ddd;
        }
    </style>



    <script src="{{ asset('assets/js/ckeditor.js') }}"></script>

    <main class="main-content  mt-0">

        <div class="container">

            <div class="row">
                <div class="col-12">
                    <div class="card mb-4">
                        <div class="card-header pb-0">
                            <h6>Search</h6>
                        </div>
                        <div class="card-body px-0 pt-0 pb-2">
                           <form action="{{ route('reportingUser') }}" method="POST" class="row">
    @csrf
    <div class="col-md-2">
    </div>
    <div class="col-md-6">
        <!-- Input field with datalist for suggestions -->
        <input type="text" class="form-control" placeholder="Document number or title" name="searchtext" list="suggestions">
        <datalist id="suggestions">
            @foreach($searchSuggestion as $suggestion)
                <option value="{{ $suggestion->doc_no }}">{{ $suggestion->subject }}</option>
            @endforeach
        </datalist>
    </div>
    <div class="col-md-4">
        <button type="submit" class="btn btn-primary btn-block">Search</button>
    </div>
</form>

                        </div>
                        @if (isset($searchResults)) 
                <table class="table align-items-center mb-0" id="myTable">
                    <thead>
                        <tr>
                            <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Document No.</th>
                            <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Title</th>
                            <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7" style="width:2% !important">Status</th>
                            <th class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Receiving Register Created by</th>
                            <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">Receiving Date</th>
                            <th class="text-secondary opacity-7"></th>
                        </tr>
                    </thead>
                    <tbody>

                     @foreach ($searchResults as $efile)
                        <tr>
                            <td class="align-middle text-center">
                                <p class="mb-0 text-sm">{{$efile->doc_no}}</p>
                            </td>  
                            <td class="align-middle text-center">
                                <p class="mb-0 text-sm">{{ $efile->subject }}</p>
                            </td>

                                
                                @php
                                $draftNow = DB::table('draftshares')->where('draft_id' , $efile->draft_id)->orderBy('id', 'DESC')->first();
                                @endphp
                                @if(isset($draftNow->touser))
                                    @php
                                        $getuname = DB::table('users')->where('id', $draftNow->touser)->first();
                                        $getusection = DB::table('departments')->where('id', $getuname->department_id)->first();
                                    @endphp
                                @endif


                            <td class="align-middle text-center">
                                @if(isset($getuname, $draftNow))
                                <p class="mb-0 text-sm">{{$getuname->jobtitle}}@if(isset($getusection))({{$getusection->name}})@endif</p>
                                @endif
                            </td>
                            <td class="align-middle text-center">
                                @php
                                    $getfileshare = DB::table('efileshares')->where('id', $efile->id)->first();
                                    $getname = DB::table('users')->where('id', $efile->sharefrom)->first();
                                    $getsection = DB::table('departments')->where('id', $getname->department_id)->first();
                                @endphp

                                <p class="mb-0 text-sm">({{$getname->jobtitle}}) - @if(isset($getsection)) {{$getsection->name}} @endif</p>
                            </td>
                            <td class="align-middle text-center">
                                <p class="mb-0 text-sm">{{ \Carbon\Carbon::parse($efile->created_at)->format('d F, Y') }}</p>
                            </td>
                             
                        </tr>
                    @endforeach
                    </tbody>
                    </table>

                        @endif

                    </div>
                </div>
            </div>


            <div class="row">
                <div class="col-12">
                    <div class="card mb-4">
                        <div class="card-header pb-0">
                            <h6>Reporting Section</h6>
                        </div>
                        <div class="card-body px-0 pt-0 pb-2">
                            <div class="table-responsive p-0">
                         

<ul class="nav nav-tabs" id="myTab" role="tablist">
  <li class="nav-item" role="presentation">
    <button class="nav-link active" id="home-tab" data-bs-toggle="tab" data-bs-target="#Current" type="button" role="tab" aria-controls="home" aria-selected="true">Current ({{$current->count()}})</button>
  </li>
  <li class="nav-item" role="presentation">
    <button class="nav-link" id="profile-tab" data-bs-toggle="tab" data-bs-target="#Pending" type="button" role="tab" aria-controls="profile" aria-selected="false">Pending ({{$pending->count()}})</button>
  </li>
  <li class="nav-item" role="presentation">
    <button class="nav-link" id="contact-tab" data-bs-toggle="tab" data-bs-target="#Approved" type="button" role="tab" aria-controls="contact" aria-selected="false">Approved ({{$approved->count()}})</button>
  </li>

</ul>
<div class="tab-content" id="myTabContent">
    <div class="tab-pane fade show active" id="Current" role="tabpanel" aria-labelledby="home-tab">
    
                <table class="table align-items-center mb-0" id="myTable">
                    <thead>
                        <tr>
                            <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Document No.</th>
                            <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Title</th>
                            <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7" style="width:2% !important">Status</th>
                            <th class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Receiving Register Created by</th>
                            <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">Receiving Date</th>
                            <th class="text-secondary opacity-7"></th>
                        </tr>
                    </thead>
                    <tbody>

                     @foreach ($current as $eaccess)
                                            @php
                                                $efile = DB::table('efileshares')
                                                    ->where('doc_type', 2)
                                                    ->where('id', $eaccess->draft_id)
                                                    ->first();
                                            @endphp
                        <tr>
                            <td class="align-middle text-center">
                                <p class="mb-0 text-sm">{{$efile->doc_no}}</p>
                            </td>  
                            <td class="align-middle text-center">
                                <p class="mb-0 text-sm">{{ $efile->subject }}</p>
                            </td>

                                
                                @php
                                $draftNow = DB::table('draftshares')->where('draft_id' , $efile->draft_id)->orderBy('id', 'DESC')->first();
                                @endphp
                                @if(isset($draftNow->touser))
                                    @php
                                        $getuname = DB::table('users')->where('id', $draftNow->touser)->first();
                                        $getusection = DB::table('departments')->where('id', $getuname->department_id)->first();
                                    @endphp
                                @endif


                            <td class="align-middle text-center">
                                @if(isset($getuname, $draftNow))
                                <p class="mb-0 text-sm">{{$getuname->jobtitle}}@if(isset($getusection))({{$getusection->name}})@endif</p>
                                @endif
                            </td>
                            <td class="align-middle text-center">
                                @php
                                    $getfileshare = DB::table('efileshares')->where('id', $efile->id)->first();
                                    $getname = DB::table('users')->where('id', $efile->sharefrom)->first();
                                    $getsection = DB::table('departments')->where('id', $getname->department_id)->first();
                                @endphp

                                <p class="mb-0 text-sm">({{$getname->jobtitle}}) - @if(isset($getsection)) {{$getsection->name}} @endif</p>
                            </td>
                            <td class="align-middle text-center">
                                <p class="mb-0 text-sm">{{ \Carbon\Carbon::parse($efile->created_at)->format('d F, Y') }}</p>
                            </td>
                             
                        </tr>
                    @endforeach
                    </tbody>
                </table>
    
    
    
    </div>
    <div class="tab-pane fade" id="Pending" role="tabpanel" aria-labelledby="profile-tab">
                  <table class="table align-items-center mb-0" id="myTable">
                    <thead>
                        <tr>
                            <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Document No.</th>
                            <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Title</th>
                            <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7" style="width:2% !important">Status</th>
                            <th class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Receiving Register Created by</th>
                            <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">Receiving Date</th>
                            <th class="text-secondary opacity-7"></th>
                        </tr>
                    </thead>
                    <tbody>

                     @foreach ($pending as $eaccess)
                                            @php
                                                $efile = DB::table('efileshares')
                                                    ->where('doc_type', 2)
                                                    ->where('id', $eaccess->draft_id)
                                                    ->first();
                                            @endphp
                        <tr>
                            <td class="align-middle text-center">
                                <p class="mb-0 text-sm">{{$efile->doc_no}}</p>
                            </td>  
                            <td class="align-middle text-center">
                                <p class="mb-0 text-sm">{{ $efile->subject }}</p>
                            </td>

                                
                                @php
                                $draftNow = DB::table('draftshares')->where('draft_id' , $efile->draft_id)->orderBy('id', 'DESC')->first();
                                @endphp
                                @if(isset($draftNow->touser))
                                    @php
                                        $getuname = DB::table('users')->where('id', $draftNow->touser)->first();
                                        $getusection = DB::table('departments')->where('id', $getuname->department_id)->first();
                                    @endphp
                                @endif


                            <td class="align-middle text-center">
                                @if(isset($getuname, $draftNow))
                                <p class="mb-0 text-sm">{{$getuname->jobtitle}}@if(isset($getusection))({{$getusection->name}})@endif</p>
                                @endif
                            </td>
                            <td class="align-middle text-center">
                                @php
                                    $getfileshare = DB::table('efileshares')->where('id', $efile->id)->first();
                                    $getname = DB::table('users')->where('id', $efile->sharefrom)->first();
                                    $getsection = DB::table('departments')->where('id', $getname->department_id)->first();
                                @endphp

                                <p class="mb-0 text-sm">({{$getname->jobtitle}}) - @if(isset($getsection)) {{$getsection->name}} @endif</p>
                            </td>
                            <td class="align-middle text-center">
                                <p class="mb-0 text-sm">{{ \Carbon\Carbon::parse($efile->created_at)->format('d F, Y') }}</p>
                            </td>
                             
                        </tr>
                    @endforeach
                    </tbody>
                </table>
    </div>
    <div class="tab-pane fade" id="Approved" role="tabpanel" aria-labelledby="contact-tab">
                          <table class="table align-items-center mb-0" id="myTable">
                    <thead>
                        <tr>
                            <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Document No.</th>
                            <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Title</th>
                            <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7" style="width:2% !important">Status</th>
                            <th class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Receiving Register Created by</th>
                            <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">Receiving Date</th>
                            <th class="text-secondary opacity-7"></th>
                        </tr>
                    </thead>
                    <tbody>

                     @foreach ($approved as $eaccess)
                                            @php
                                                $efile = DB::table('efileshares')
                                                    ->where('doc_type', 2)
                                                    ->where('id', $eaccess->draft_id)
                                                    ->first();
                                            @endphp
                        <tr>
                            <td class="align-middle text-center">
                                <p class="mb-0 text-sm">{{$efile->doc_no}}</p>
                            </td>  
                            <td class="align-middle text-center">
                                <p class="mb-0 text-sm">{{ $efile->subject }}</p>
                            </td>

                                
                                @php
                                $draftNow = DB::table('draftshares')->where('draft_id' , $efile->draft_id)->orderBy('id', 'DESC')->first();
                                @endphp
                                @if(isset($draftNow->touser))
                                    @php
                                        $getuname = DB::table('users')->where('id', $draftNow->touser)->first();
                                        $getusection = DB::table('departments')->where('id', $getuname->department_id)->first();
                                    @endphp
                                @endif


                            <td class="align-middle text-center">
                                @if(isset($getuname, $draftNow))
                                <p class="mb-0 text-sm">{{$getuname->jobtitle}}@if(isset($getusection))({{$getusection->name}})@endif</p>
                                @endif
                            </td>
                            <td class="align-middle text-center">
                                @php
                                    $getfileshare = DB::table('efileshares')->where('id', $efile->id)->first();
                                    $getname = DB::table('users')->where('id', $efile->sharefrom)->first();
                                    $getsection = DB::table('departments')->where('id', $getname->department_id)->first();
                                @endphp

                                <p class="mb-0 text-sm">({{$getname->jobtitle}}) - @if(isset($getsection)) {{$getsection->name}} @endif</p>
                            </td>
                            <td class="align-middle text-center">
                                <p class="mb-0 text-sm">{{ \Carbon\Carbon::parse($efile->created_at)->format('d F, Y') }}</p>
                            </td>
                             
                        </tr>
                    @endforeach
                    </tbody>
                </table>
    </div>
  

  
</div>




                            </div>
                        </div>
                    </div>
                </div>
            </div>








        </div>

    </main>



<script>
$(function() {
    // Fetch the data from the server and convert it to an array of suggestions
    var suggestions = {!! $searchSuggestion->pluck(['doc_no', 'subject']) !!};

    // Initialize jQuery UI Autocomplete
    $("#searchtext").autocomplete({
        source: suggestions,
        select: function(event, ui) {
            // When a suggestion is selected, set the value in the hidden input field
            $("#selected_suggestion").val(ui.item.value);
        }
    });
});
</script>
@endsection
