<?php

namespace App\Http\Controllers\Members;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Efileshare;
use App\Models\Finaldocument;
use App\Models\Lawyerfinaldocument;
use App\Models\Draft_attachment;
use App\Models\Draftshare;
use App\Models\Draftremark;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use App\Exports\RecordsExport;
use Maatwebsite\Excel\Facades\Excel;
use Carbon\Carbon;
use App\Models\File;
use Auth;



class EfileController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }
    
    

    public function changepswd(Request $request)
    {
        
        // Validate the form data
      
    
        // Get the current user
        $user = auth()->user();
    

      
        // Check if the old password matches the user's current password
        if (Hash::check($request->oldpswd, $user->password)) {
            // Update the user's password with the new password
            $user->password = Hash::make($request->newpswd);
            $user->save();
    
            return redirect()->route('home')->with('success', 'Password changed successfully.');
           // return redirect()->route('change.password.form')->with('success', 'Password changed successfully.');
        } else {
            return redirect()->route('home')->with('error', 'Old password is incorrect.');
        }
    }


    
    public function changepin(Request $request)
    {
        
        // Validate the form data
     
    
        // Get the current user
        $user = auth()->user();
    
     
     
        // Check if the old password matches the user's current password
        if (Hash::check($request->oldpin, $user->pin)) {
           
            // Update the user's password with the new password
            $user->pin = Hash::make($request->newpin);
            $user->save();
    
            return redirect()->route('home')->with('success1', 'Pin changed successfully.');
           // return redirect()->route('change.password.form')->with('success', 'Password changed successfully.');
        } else {
            return redirect()->route('home')->with('error1', 'Old pin is incorrect.');
        }
    }






    public function sendfile()
    {
        $users = DB::table('users')->where('odep_id' , Auth::user()->odep_id)->where('id', '<>' ,Auth::user()->id)->where('is_admin' , 0)->get();
       
      $efiles = DB::table('draftshares')->where('doc_type' , 1)->where('fromuser' , Auth::user()->id)->orWhere('touser' , Auth::user()->id)->orderBy('id', 'DESC')->distinct()->get(['draft_id']);
    return view('member-view.sendFile', ['users' => $users, 'efiles' => $efiles]);

    }
    
    
    
 
    
    
    
    
    
    
    
     public function sendletter()
    {
        $users = DB::table('users')->where('odep_id' , Auth::user()->odep_id)->where('id', '<>' ,Auth::user()->id)->where('is_admin' , 0)->get();
        $efiles = DB::table('draftshares')->where('doc_type' , 2)->where('fromuser' , Auth::user()->id)->orderBy('id', 'DESC')->distinct()->get(['draft_id']);
        return view('member-view.sendFile', ['users' => $users, 'efiles' => $efiles]);
    }

    

    public function currentfile()
    {
        $today = Carbon::today()->toDateString();
        $users = DB::table('users')->where('odep_id' , Auth::user()->odep_id)->where('id', '<>' ,Auth::user()->id)->where('is_admin' , 0)->get();
        $efiles = DB::table('draftshares')->where('doc_type' , 2)->where('touser' , Auth::user()->id)->where('close' , 0)->whereDate('created_at', $today)->where('approved' , 0)->orderBy('id', 'DESC')->distinct()->get(['draft_id']);
        return view('member-view.currentfiles', ['users' => $users, 'efiles' => $efiles]);
    }


    public function sendedfile()
    {
        $users = DB::table('users')->where('odep_id' , Auth::user()->odep_id)->where('id', '<>' ,Auth::user()->id)->where('is_admin' , 0)->get();
        $efiles = DB::table('draftshares')->where('doc_type' , 2)->where('fromuser' , Auth::user()->id)->orderBy('id', 'DESC')->distinct()->get(['draft_id']);
       
        return view('member-view.sendedfiles', ['users' => $users, 'efiles' => $efiles]);
    }

    

    public function pendingfile()
    {
        $today = Carbon::today()->toDateString();
        $users = DB::table('users')->where('odep_id' , Auth::user()->odep_id)->where('id', '<>' ,Auth::user()->id)->where('is_admin' , 0)->get();
        $efiles = DB::table('draftshares')->where('doc_type' , 2)->where('touser' , Auth::user()->id)->where('close' , 0)->where('approved' , 0)->whereDate('created_at', '<>', $today)->orderBy('id', 'DESC')->distinct()->get(['draft_id']);
        return view('member-view.pendingfiles', ['users' => $users, 'efiles' => $efiles]);
    }

    


    public function approvedfile()
    {
        $today = Carbon::today()->toDateString();
        $users = DB::table('users')->where('odep_id' , Auth::user()->odep_id)->where('id', '<>' ,Auth::user()->id)->where('is_admin' , 0)->get();
        $efiles = DB::table('draftshares')->where('doc_type' , 2)->where('touser' , Auth::user()->id)->where('approved' , 1)->orderBy('id', 'DESC')->distinct()->get(['draft_id']);
       
    
        
        if(Auth::user()->jobtitle == 'Secretary')
        {
            $efiles = DB::table('draftshares')->where('doc_type' , 2)->where('fromuser' , Auth::user()->id)->where('approved' , 1)->orderBy('id', 'DESC')->distinct()->get(['draft_id']);
            return view('member-view.approvedfiles', ['users' => $users, 'efiles' => $efiles]);
        }
        else
        {
           // $efiles = DB::table('draftshares')->where('doc_type' , 2)->where('touser' , Auth::user()->id)->where('approved' , 1)->orderBy('id', 'DESC')->distinct()->get(['draft_id']);
            
            $getapprovedfiles = DB::table('draftshares')->where(function ($query) {
                $query->where('touser', Auth::user()->id)
                      ->orWhere('fromuser', Auth::user()->id);
                    })
                    ->where('doc_type', 2)->orderBy('id', 'DESC')->distinct()->get(['draft_id']);
            
                    $efiles = DB::table('draftshares')
                    ->whereIn('draft_id', $getapprovedfiles->pluck('draft_id'))
                    ->where('approved', 1)
                    ->get();  
            
            
            
            
            
            return view('member-view.approvedfiles', ['users' => $users, 'efiles' => $efiles]);
        }

    
        
        
    }


    
         public function sendletterform()
    {
            
       
          
            $users = DB::table('users')->where('odep_id' , Auth::user()->odep_id)->where('id', '<>' ,Auth::user()->id)->where('is_admin' , 0)->get();
            return view('member-view.sendFileForm', ['users' => $users]);
            
            
            
           
    }
    
    
    
     public function sendsummary()
    {
        $users = DB::table('users')->where('odep_id' , Auth::user()->odep_id)->where('id', '<>' ,Auth::user()->id)->where('is_admin' , 0)->get();
       $efiles = DB::table('draftshares')->where('doc_type' , 3)->where('fromuser' , Auth::user()->id)->orWhere('touser' , Auth::user()->id)->orderBy('id', 'DESC')->distinct()->get(['draft_id']);
     return view('member-view.sendFile', ['users' => $users, 'efiles' => $efiles]);

    }
    
       public function deletedraft(Request $request)
    {
    DB::table('efileshares')->delete($request->delid);
     DB::table('draftshares')->where('draft_id', $request->delid)->delete();
    return redirect()->back();
    }






    public function uploadefile(Request $request)
    {
        
        $user = auth()->user();
     

        

        if (Hash::check($request->pin, $user->pin)) {
           
        } else {
            return back()->with('error', 'Incorrect PIN. Please try again.');
        }

        
        


        $fileModel = new Efileshare;

        $file = $request->file('mydraftfile');

        if ($file) {
            $fileName = time() . '_' . $file->getClientOriginalName();
            $file->storeAs('uploads', $fileName, 'public');
            $fileModel->file_path = $fileName;
        }
        


        $fileModel->doc_no = $request['doc_no'];
        $fileModel->law_doc_no = $request['law_doc_no'];
        $fileModel->sharefrom = $request['filesharefrom'];
        $fileModel->shareto = $request['fileshareto'];

        $fileModel->draft_text = $request['draft_text'];
        $fileModel->subject = $request['subject'];
        $fileModel->department_id = $request['depid'];
        $fileModel->doc_type = $request['doc_type'];
        $fileModel->draft_type = $request['draft_type'];
        $fileModel->nottings = $request['nottings'];
        $fileModel->asigned_section = $request['asigned_section'];
        
        $fileModel->rec_dep = $request['rec_dep'];

        $fileModel->created_at = Carbon::now();
        $fileModel->updated_at = Carbon::now();
        $fileModel->save();



       
        if($request->file)
        {     
        $countimages = max(array_keys($request->file));
       
   

        for ($i = 0; $i <= $countimages; $i++) {

            
        $draftimages= new Draft_attachment;
        if (isset($request->file('file')[$i])) {
        $fileName = time().'_'.$request->file[$i]->getClientOriginalName();
       
        $filePath = $request->file('file')[$i]->storeAs('uploads', $fileName, 'public');
       
        $draftimages->path = $filePath;
        $draftimages->draft_id = $fileModel->id;
        $draftimages->created_at = Carbon::now();
        $draftimages->updated_at = Carbon::now();
        $draftimages->save();
        }


        }
    
        }
        
        
        $draftrecords = new Draftshare;
    
        $draftrecords->fromuser = $request['filesharefrom'];
        $draftrecords->touser = $request['fileshareto'];
        $draftrecords->draft_id = $fileModel->id;
        $draftrecords->doc_type = $request['doc_type'];
        $draftrecords->created_at = Carbon::now();
        $draftrecords->updated_at = Carbon::now();
        $draftrecords->save();
        

        // $users = DB::table('users')->where('is_admin' , 0)->orWhere('is_admin' , Null)->get();
        // return view('home', ['users' => $users]);
        
        
        
            return redirect('/home');
        
        
    }


    
    public function uploadefileproceed(Request $request)
    {
        $user = auth()->user();
     

        

        if (Hash::check($request->pin, $user->pin)) {
           
        } else {
            return back()->with('error', 'Incorrect PIN. Please try again.');
        }









        if($request['fileshareto'])
        {
            DB::table('draftshares')->where('touser', $request['oldfilesharefrom'])->update(['close' => 1]);
            


            $checklastapproval = DB::table('draftshares')->where('draft_id', $request['id'])->where('approved', 1)->first();

            if($request['jobtitleuser'] == 'Secretary')
                {
                if (isset($request['notify']))
                    {
                Draftshare::insert([
                'touser' => $request['fileshareto'],
                'fromuser' => $request['oldfilesharefrom'],
                'draft_id' => $request['id'],
                'approved' => 1,
                'doc_type' => $request['doc_type'],
                'created_at'  => Carbon::now(),
                'updated_at'  => Carbon::now()
                            ]);
                    }

                    else
                    {
                Draftshare::insert([
                'touser' => $request['fileshareto'],
                'fromuser' => $request['oldfilesharefrom'],
                'draft_id' => $request['id'],
                'approved' => 0,
                'doc_type' => $request['doc_type'],
                'created_at'  => Carbon::now(),
                'updated_at'  => Carbon::now()
                            ]);
                    }

                }
            elseif($checklastapproval)
            {
                Draftshare::insert([
                    'touser' => $request['fileshareto'],
                    'fromuser' => $request['oldfilesharefrom'],
                    'draft_id' => $request['id'],
                    'approved' => 1,
                    'doc_type' => $request['doc_type'],
                    'created_at'  => Carbon::now(),
                    'updated_at'  => Carbon::now()
                                ]);
            }
            else
            {
                Draftshare::insert([
                    'touser' => $request['fileshareto'],
                    'fromuser' => $request['oldfilesharefrom'],
                    'draft_id' => $request['id'],
                    'doc_type' => $request['doc_type'],
                    'created_at'  => Carbon::now(),
                    'updated_at'  => Carbon::now()
                                ]);
            }
           
        }
      
    

       


            $efileshare = Efileshare::find($request['id']);
            
            $efileshare->subject = $request['subject'];
            $efileshare->asigned_section = $request['asigned_section'];
            
            $efileshare->draft_text = $request['draft_text'];
            $efileshare->draft_id = $request['id'];

            if ($request->hasFile('mydraftfile')) {
                $newFilePath = $request->file('mydraftfile')->getClientOriginalName();
                $request->file('mydraftfile')->storeAs('public/uploads', $newFilePath);
                $efileshare->file_path = $newFilePath;
            }


            $efileshare->save();
            
     
            if($request->file('file'))
            {

                $usersscale = DB::table('users')->where('id' , $request['oldfilesharefrom'])->first();

                $draftimages= new Draftremark;
                $fileName = time().'_'.$request->file->getClientOriginalName();
               
                $filePath = $request->file('file')->storeAs('uploads', $fileName, 'public');
               
                $draftimages->remark = $filePath;
                $draftimages->touser = $request['fileshareto'];
                $draftimages->user_id = $request['oldfilesharefrom'];
                $draftimages->scale_id = $usersscale->scale_level;
                $draftimages->job_title = $request['jobtitleuser'];
                $draftimages->notify = $request['notify'];
                $draftimages->mac_id = $request->ip();

                $draftimages->draft_id = $request['id'];
                $draftimages->created_at = Carbon::now();
                $draftimages->updated_at = Carbon::now();
                $draftimages->save();
            }




 
            
         if($request['remarks'] || $request['notify'])
        {   
                $usersscale = DB::table('users')->where('id' , $request['oldfilesharefrom'])->first();

                
                
                $remarks = $request['remarks'];
                $lines = explode("<p>", $remarks); // Split the input text into an array of lines
                
                $firstIteration = true; // Flag variable to track the first iteration

                foreach ($lines as $line) {
                    $trimmedLine = trim($line); // Trim whitespace from the line
                
                    if (!empty($trimmedLine)) {
                        $draftremarkData = [
                            'touser' => $request['fileshareto'],
                            'user_id' => ($firstIteration) ? $request['oldfilesharefrom'] : null,
                            "scale_id" => $usersscale->scale_level,
                            'job_title' => $request['jobtitleuser'],
                            'remark' => $trimmedLine,
                            'notify' => $request['notify'],
                            'draft_id' => $request['id'],
                            'mac_id' => $request->ip(),
                            'created_at' => Carbon::now(),
                            'updated_at' => Carbon::now()
                        ];
                
                        Draftremark::insert($draftremarkData);
                
                        $firstIteration = false; // Set the flag to false after the first iteration
                    }
                }
                
                




          
            
        }
   
        $users = DB::table('users')->where('is_admin' , 0)->orWhere('is_admin' , Null)->get();
        $efiles = DB::table('efileshares')->where('shareto' , Auth::user()->id)->get();
        return redirect()->back();

    }





    public function inboxfiles()
    {
        $users = DB::table('users')->where('is_admin' , 0)->orWhere('is_admin' , Null)->get();
        $efiles = DB::table('finaldocuments')->where('doc_type' , 1)->where('shareto' , Auth::user()->id)->orderBy('id', 'DESC')->get();
        return view('member-view.viewInbox', ['efiles' => $efiles], ['users' => $users]);
    }

    public function outboxfiles()
    {
          $efiles = DB::table('finaldocuments')->where('doc_type' , 1)->where('sharefrom' , Auth::user()->id)->orderBy('id', 'DESC')->get();
        return view('member-view.viewOutbox', ['efiles' => $efiles]);
    }
    
    
    
        public function inboxletter()
    {
         $users = DB::table('users')->where('is_admin' , 0)->orWhere('is_admin' , Null)->get();
        // // $efiles = DB::table('finaldocuments')->where('doc_type' , 2)->where('shareto' , Auth::user()->id)->orderBy('id', 'DESC')->get();
        // $efiles = DB::table('draftshares')->where('doc_type' , 2)->where('fromuser' , Auth::user()->id)->orWhere('touser' , Auth::user()->id)->orderBy('id', 'DESC')->distinct()->get(['draft_id']);
    
        $efiles = DB::table('finaldocuments')->where('doc_type' , 2)->where('shareto' , Auth::user()->id)->orderBy('id', 'DESC')->get();
        return view('member-view.viewInbox', ['efiles' => $efiles], ['users' => $users]);
    }

    
    public function maininboxletter()
    {
         $users = DB::table('users')->where('is_admin' , 0)->orWhere('is_admin' , Null)->get();
    
        $efiles = DB::table('finaldocuments')->where('doc_type' , 2)->where('sharefrom' , Auth::user()->id)->orderBy('id', 'DESC')->get();
        return view('member-view.viewMainInbox', ['efiles' => $efiles], ['users' => $users]);
    }





    public function outboxletter()
    {
        $efiles = DB::table('finaldocuments')->where('doc_type' , 2)->where('sharefrom' , Auth::user()->id)->orderBy('id', 'DESC')->get();
        return view('member-view.viewOutbox', ['efiles' => $efiles]);
    }
    
    
    
        public function inboxnotting()
    {
        $users = DB::table('users')->where('is_admin' , 0)->orWhere('is_admin' , Null)->get();
        
        $efiles = DB::table('finaldocuments')->where('doc_type' , 3)->where('shareto' , Auth::user()->id)->orderBy('id', 'DESC')->get();
  
        return view('member-view.viewInbox', ['efiles' => $efiles], ['users' => $users]);
    }

    public function outboxnotting()
    {
         $efiles = DB::table('finaldocuments')->where('doc_type' , 3)->where('sharefrom' , Auth::user()->id)->orderBy('id', 'DESC')->get();
        return view('member-view.viewOutbox', ['efiles' => $efiles]);
    }


 public function getDepartmentUser($department_id)
    {

         $data =  DB::table('users')->where('odep_id' , $department_id)->where('is_admin' , 0)->orWhere('is_admin' , Null)->get();
         
        return response()->json(['data' => $data]);
    }


    public function senddocument(Request $request)
    {
        
      
       $dep = DB::table('odepartments')->get();
  
        $members = DB::table('users')->where('is_admin' , 0)->orWhere('is_admin' , Null)->get();
        $efiles = DB::table('efileshares')->where('id' , $request->id)->first();
        return view('member-view.senddocument', ['efiles' => $efiles, 'dep' => $dep, 'members' => $members]);
    }
    
    
     public function senddoctodep(Request $request)
    {
       
   
       
       for($i=0; $i<count($request['shareto']); $i++)
       
       {
       
           if($request['new_department_id'] == 7)
           {
               
                $username= DB::table('users')->where('id' , $request['sharefrom'])->first();
                $recusername= DB::table('users')->where('id' , $request['shareto'][$i])->first();
                $depname= DB::table('odepartments')->where('id' , $request['old_department_id'])->first();
               
               
               DB::connection('mysqllive')->insert('insert into lawyerfinaldocuments(uniquenumber, name, file_path, sharefrom, fromdep, doc_type, doc_details, ccto, subject, remarks, todep, shareto, fromusername, fromdepname,tousername, created_at, updated_at) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)',
               [$request['uniqueid'], 
               $request['name'],
               $request['file_path'], 
               $request['sharefrom'], 
               $request['old_department_id'],  
               $request['doc_type'], 
               $request['draft_text'], 
               $request['ccto'], 
               $request['subject'], 
               $request['remarks'], 
               $request['new_department_id'], 
               $request['shareto'][$i], 
               $username->name,
               $depname->name, 
               $recusername->name,
               Carbon::now(), 
               Carbon::now() ]);

               
               

               $newfilenae = str_replace("uploads/","",$request['file_path']);

              // $localFilePath = "/storage/app/public/".$request['file_path'];
              $localFilePath ="storage/".$request['file_path'];
                $remoteFilePath = '/'.$newfilenae;
                $server = 'pakmultiservices.com';
                $username = 'ajklaw@pakmultiservices.com';
                $password = ')g3S@YvOQ~}A';

                // Establish an FTP connection
                $ftpConnection = ftp_connect($server);
                if (!$ftpConnection) {
                    die('Failed to connect to the server.');
                }

                // Login to the FTP server
                $login = ftp_login($ftpConnection, $username, $password);
                if (!$login) {
                    die('Failed to log in to the server.');
                }

                // Enable passive mode (optional)
                ftp_pasv($ftpConnection, true);

                // Copy the file to the remote server
                $upload = ftp_put($ftpConnection, $remoteFilePath, $localFilePath, FTP_BINARY);
                if (!$upload) {
                    die('Failed to upload the file.');
                }

                // Close the FTP connection
                ftp_close($ftpConnection);

          

               
              
        
        
           }
           
           


           Finaldocument::insert([
            'uniquenumber' => $request['uniqueid'],
            'name' => $request['name'],
            'draft_id' => $request['draft_id'],
            'file_path' => $request['file_path'],
            'sharefrom' => $request['sharefrom'],
            'fromdep' => $request['old_department_id'],
            'doc_type' => $request['doc_type'],
            'doc_details' => $request['draft_text'],
            'ccto' => $request['ccto'],
            'subject' => $request['subject'],
            'remarks' => $request['remarks'],
            'todep' => $request['new_department_id'],
            'shareto' => $request['shareto'][$i],
            'created_at'  => Carbon::now(),
            'updated_at'  => Carbon::now()
            ]); 

           
        
       }
        
        
        
       
      // $usersscale = DB::table('users')->where('id' , $request['oldfilesharefrom'])->first();    
       $remarks = $request['myremakrs'];
       $lines = explode("<p>", $remarks); // Split the input text into an array of lines
       foreach ($lines as $line) {
           $trimmedLine = trim($line); // Trim whitespace from the line
           if (!empty($trimmedLine)) {
               Draftremark::insert([
                  
                   'user_id' => 25,
                   "scale_id" => 5,
                   'job_title' => 'SO',
                   'remark' => $trimmedLine,
                   'draft_id' => $request['draft_id'],
                   'mac_id' => $request->ip(),
                   'created_at' => Carbon::now(),
                   'updated_at' => Carbon::now()
               ]);
            }
         }







       $efileshare = Efileshare::find($request['draft_id']);
       $efileshare->draft_text = $request['draft_text'];
       $efileshare->save();




       
       return redirect('/home');
    }
    
    
    
     public function printdoc(Request $request)
    {
       
         $efiles = DB::table('finaldocuments')->where('id' , $request->id)->first();
          return view('member-view.printdocument', ['efiles' => $efiles]);
    }


    
    
    public function printnoting(Request $request)
    {
       
         $efiles = DB::table('finaldocuments')->where('id' , $request->id)->first();
          return view('member-view.printnoting', ['efiles' => $efiles]);
    }
    
    

    public function getdepusers(Request $request)
    {
       echo 'here';
       die();
          return view('member-view.printdocument');
    }
    




    

public function currentexport()
{
    return Excel::download(new RecordsExport(), 'currentrecords.xlsx');
}



public function reportingUser(Request $request)
{



if(Auth::user()->id == 1)
    {
        if (isset($request->searchtext)) 
        {
            $searchResults = Efileshare::where('doc_no', $request->searchtext)->orWhere('subject', $request->searchtext)->get();
            
            $searchSuggestion = Efileshare::latest()->get();
            $today = Carbon::today()->toDateString();
            $users = DB::table('users')->where('odep_id' , Auth::user()->odep_id)->where('id', '<>' ,Auth::user()->id)->where('is_admin' , 0)->get();
            $current = DB::table('draftshares')->where('doc_type' , 2)->where('close' , 0)->whereDate('created_at', $today)->where('approved' , 0)->orderBy('id', 'DESC')->distinct()->get(['draft_id']);
            $pending = DB::table('draftshares')->where('doc_type' , 2)->where('close' , 0)->where('approved' , 0)->whereDate('created_at', '<>', $today)->orderBy('id', 'DESC')->distinct()->get(['draft_id']);
            $approved = DB::table('draftshares')->where('doc_type' , 2)->where('approved' , 1)->orderBy('id', 'DESC')->distinct()->get(['draft_id']);
            return view('admin-view.reporting', ['users' => $users, 'current' => $current, 'pending' => $pending, 'approved' => $approved, 'searchResults' => $searchResults, 'searchSuggestion' => $searchSuggestion]);
        }

    else
        {
        $searchSuggestion = Efileshare::latest()->get();
        $today = Carbon::today()->toDateString();
        $users = DB::table('users')->where('odep_id' , Auth::user()->odep_id)->where('id', '<>' ,Auth::user()->id)->where('is_admin' , 0)->get();
        $current = DB::table('draftshares')->where('doc_type' , 2)->where('close' , 0)->whereDate('created_at', $today)->where('approved' , 0)->orderBy('id', 'DESC')->distinct()->get(['draft_id']);
        $pending = DB::table('draftshares')->where('doc_type' , 2)->where('close' , 0)->where('approved' , 0)->whereDate('created_at', '<>', $today)->orderBy('id', 'DESC')->distinct()->get(['draft_id']);
        $approved = DB::table('draftshares')->where('doc_type' , 2)->where('approved' , 1)->orderBy('id', 'DESC')->distinct()->get(['draft_id']);
        return view('admin-view.reporting', ['users' => $users, 'current' => $current, 'pending' => $pending, 'approved' => $approved, 'searchSuggestion' => $searchSuggestion]);
        }
    }

else
    {
    if (isset($request->searchtext)) 
        {
            $searchResults = Efileshare::where('doc_no', $request->searchtext)->orWhere('subject', $request->searchtext)->get();
            
            $searchSuggestion = Efileshare::latest()->get();
            $today = Carbon::today()->toDateString();
            $users = DB::table('users')->where('odep_id' , Auth::user()->odep_id)->where('id', '<>' ,Auth::user()->id)->where('is_admin' , 0)->get();
            $current = DB::table('draftshares')->where('doc_type' , 2)->where('close' , 0)->whereDate('created_at', $today)->where('approved' , 0)->orderBy('id', 'DESC')->distinct()->get(['draft_id']);
            $pending = DB::table('draftshares')->where('doc_type' , 2)->where('close' , 0)->where('approved' , 0)->whereDate('created_at', '<>', $today)->orderBy('id', 'DESC')->distinct()->get(['draft_id']);
            $approved = DB::table('draftshares')->where('doc_type' , 2)->where('approved' , 1)->orderBy('id', 'DESC')->distinct()->get(['draft_id']);
            return view('member-view.reporting', ['users' => $users, 'current' => $current, 'pending' => $pending, 'approved' => $approved, 'searchResults' => $searchResults, 'searchSuggestion' => $searchSuggestion]);
        }

    else
        {
        $searchSuggestion = Efileshare::latest()->get();
        $today = Carbon::today()->toDateString();
        $users = DB::table('users')->where('odep_id' , Auth::user()->odep_id)->where('id', '<>' ,Auth::user()->id)->where('is_admin' , 0)->get();
        $current = DB::table('draftshares')->where('doc_type' , 2)->where('close' , 0)->whereDate('created_at', $today)->where('approved' , 0)->orderBy('id', 'DESC')->distinct()->get(['draft_id']);
        $pending = DB::table('draftshares')->where('doc_type' , 2)->where('close' , 0)->where('approved' , 0)->whereDate('created_at', '<>', $today)->orderBy('id', 'DESC')->distinct()->get(['draft_id']);
        $approved = DB::table('draftshares')->where('doc_type' , 2)->where('approved' , 1)->orderBy('id', 'DESC')->distinct()->get(['draft_id']);
        return view('member-view.reporting', ['users' => $users, 'current' => $current, 'pending' => $pending, 'approved' => $approved, 'searchSuggestion' => $searchSuggestion]);
        }
    }
}




public function searchdoc(Request $request)
{
     
    //  echo $request->searchtext;
    // die();



    $searchfiles = Draftshare::where(function ($query) {
        $query->where('touser', Auth::user()->id)
              ->orWhere('fromuser', Auth::user()->id);
    })
    ->where('doc_type', 2)
    ->orderBy('id', 'DESC')
    ->distinct()
    ->pluck('draft_id'); // Pluck only the 'draft_id' values into an array
    
    $dataFromOtherTable = Efileshare::whereIn('id', $searchfiles)
                      ->get();

               
    
          
}


}