<?php
namespace App\Http\Controllers\Auth;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Http\Request;




class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */
    use AuthenticatesUsers;
    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    // protected $redirectTo = '/admin/route';
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest')->except('logout');
    }
    public function login(Request $request)
    {  
        
       
        $inputVal = $request->all();
   
        $this->validate($request, [
            'email' => 'required|email',
            'password' => 'required',
        ]);
   
        if(auth()->attempt(array('email' => $inputVal['email'], 'password' => $inputVal['password']))){
            if (auth()->user()->is_admin == 1) {
                return redirect()->route('admin.route');
            }
            elseif(auth()->user()->odep_id == 7){
                return redirect()->route('homelawyer');
            }
            else{
                return redirect()->route('home');
            }
        }else{
            return redirect()->route('login')
                ->with('error','Email & Password are incorrect.');
        }     
    }
    
    
    
    public function loginapp(Request $request)
{
   
    // $credentials = $request->only(['email', 'password']);

    // if (!Auth::attempt($credentials)) {
    //     return response()->json(['error' => 'Unauthorized'], 401);
    // }

    // $user = $request->user();
    // $token = $user->createToken('API Token')->accessToken;
    // return response()->json(['token' => $token]);

    $data = [
        'email' => $request->email,
        'password' => $request->password
    ];

    if (auth()->attempt($data)) {

        auth()->user()->tokens()->delete();
        $token = auth()->user()->createToken('APIToken')->plainTextToken;
        return response()->json(['token' => $token], 200);
    } else {
        $errors = [];
        array_push($errors, ['code' => 'auth-001', 'message' => trans('custom.login_failed')]);
        return response()->json([
            'errors' => $errors
        ], 401);
    }






   
}

public function logoutapp(Request $request){
    $request->user()->currentAccessToken()->delete();
            return response()->json(
                [
                    'status' => 'success',
                    'message' => 'User logged out successfully'
                ]);
}







    
    
    
}