<?php

namespace App\Exports;

use App\Models\User;
use Maatwebsite\Excel\Concerns\FromCollection;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;
use Auth;

class RecordsExport implements FromCollection
{
    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
      
        $today = Carbon::today()->toDateString();
    
        $ids = DB::table('draftshares')
            ->where('doc_type', 2)
            ->where('touser', Auth::user()->id)
            ->where('close', 0)
            ->whereDate('created_at', $today)
            ->where('approved', 0)
            ->orderBy('id', 'DESC')
            ->distinct()
            ->pluck('draft_id');
    
     
        $records = DB::table('efileshares')->select('doc_no', 'subject', 'draft_text', 'nottings', 'asigned_section', 'rec_dep', 'created_at')
            ->whereIn('id', $ids)
            ->get();
    
        return $records;
    }
}
